#!/bin/sh
#created by v_shiweiliu 2020-07-17
#MRCP Server stop script

CRONTAB_BAK_FILE="./crontab.bak"
curr_dir=$(dirname "$PWD")
mrcp_conf=${curr_dir}/admin/conf.ini
log_suf=`date "+%Y%m%d%H"`
log_name="../log/nohup.log.${log_suf}"

SIP_SERVER_PORT=$(grep '^server_sip_port' ${mrcp_conf} |awk -F '=' '{print $2}')
MRCP_SERVER_PORT=$(grep '^server_mrcp_port' ${mrcp_conf} |awk -F '=' '{print $2}')
ALIVE_STATUS=0
DEAD_STATUS=1
UNKNOWN_STATUS=2
WAIT_SECONDS=90
CHECK_INTERVAL_SECONDS=1


function create_crontab()
{
        echo 'Create crontab task...'
        crontab -l > ${CRONTAB_BAK_FILE} 2>/dev/null
        #del repeat crontab task
        sed -i '\#cd .*/admin/; ./start_server.sh#d' ${CRONTAB_BAK_FILE}
        echo "* * * * * cd ${curr_dir}/admin/; ./start_server.sh 2>&1>/dev/null" >> ${CRONTAB_BAK_FILE}
        crontab ${CRONTAB_BAK_FILE}
        rm ${CRONTAB_BAK_FILE}
        echo "Create crontab task complete."
}

function check() {
    want_status=$1
    wait_seconds=$2

    now=$(date +%s)
    ((wait_to_ts=now+wait_seconds))
    #echo "server port: $SIP_SERVER_PORT
    if [ "x${SIP_SERVER_PORT}" != "x" -a "x${MRCP_SERVER_PORT}" != "x" ];then
        now=$(date +%s)
        while [ $now -lt $wait_to_ts ];do
            netstat -lnt | grep $SIP_SERVER_PORT | grep 'LISTEN' 2>&1 > /dev/null
            status=$?
            netstat -lnt | grep $MRCP_SERVER_PORT | grep 'LISTEN' 2>&1 > /dev/null
            status2=$?
            if [ $status -eq $want_status -a $status2 -eq $want_status ];then
                echo "SIP and MRCP port ok"
                return $status
            fi
            echo "[$(date)][wait to be ready][status:$status]"
            sleep $CHECK_INTERVAL_SECONDS
        done
        return $DEAD_STATUS
    else
        #echo "port unknown"
        return $UNKNOWN_STATUS
    fi
}

# start
export LD_LIBRARY_PATH=${curr_dir}/lib:$LD_LIBRARY_PATH
procnum=`ps -ef | grep '[/]bin/unimrcpserver' `
if [ "$procnum" != "" ]; then
    echo "$procnum, MRCP Server has already started!" 
    exit 1
else
    create_crontab
    ulimit -c unlimited
    echo "$curr_dir/core-%e-%p-%t" > /proc/sys/kernel/core_pattern
    nohup $curr_dir/bin/unimrcpserver -r $curr_dir -l 7 -o 3 -d >$log_name 2>&1 &
    echo "MRCP Server  start success!",$procnum >> $log_name
fi

check $ALIVE_STATUS $WAIT_SECONDS
if [ $? -eq $ALIVE_STATUS ];
then
    echo -e "\e[1;32mMRCP Server start succeed\e[0m"
    exit 0
else
    echo -e "\e[1;31mMRCP Server startfailed\e[0m"
    exit 1
fi


